/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.commonmc.api.client.gui.util;

import com.thecsdev.commonmc.api.client.gui.TElement;
import com.thecsdev.commonmc.api.client.gui.util.TGuiUtils;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SceneGraphPath {
    @NotNull
    private final Class<? extends TElement> child;
    private final int childIndex;
    @Nullable
    private final SceneGraphPath next;

    public SceneGraphPath(@NotNull Class<? extends TElement> child, int childIndex, @Nullable SceneGraphPath path) throws NullPointerException {
        this.child = Objects.requireNonNull(child);
        this.childIndex = childIndex;
        this.next = path;
    }

    @NotNull
    public Class<? extends TElement> getChild() {
        return this.child;
    }

    public int getChildIndex() {
        return this.childIndex;
    }

    @Nullable
    public SceneGraphPath getNext() {
        return this.next;
    }

    @Nullable
    public final TElement resolve(@NotNull TElement from) throws NullPointerException {
        return SceneGraphPath.resolve(from, this);
    }

    @Nullable
    public static final SceneGraphPath of(@NotNull TElement from, @Nullable TElement to) {
        TElement parent;
        Objects.requireNonNull(from);
        if (to == null || !TGuiUtils.isAncestor(to, from)) {
            return null;
        }
        TElement current = to;
        SceneGraphPath path = null;
        while (current != from && (parent = (TElement)current.getParent()) != null) {
            int index = parent.indexOf(current);
            path = new SceneGraphPath(current.getClass(), index, path);
            current = parent;
        }
        if (current != from) {
            return null;
        }
        return path;
    }

    @Nullable
    public static final TElement resolve(@NotNull TElement from, @NotNull SceneGraphPath path) throws NullPointerException {
        Objects.requireNonNull(from);
        Objects.requireNonNull(path);
        TElement current = from;
        for (SceneGraphPath segment = path; segment != null; segment = segment.getNext()) {
            Class<? extends TElement> expectedType = segment.getChild();
            int expectedIndex = segment.getChildIndex();
            if (expectedIndex < 0 || expectedIndex >= current.size()) {
                return null;
            }
            TElement child = (TElement)current.get(expectedIndex);
            if (child == null) {
                return null;
            }
            if (!expectedType.isInstance(child)) {
                return null;
            }
            current = child;
        }
        return current;
    }
}

