/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.commonmc.api.client.gui.util;

import com.thecsdev.common.math.Bounds2i;
import com.thecsdev.commonmc.api.client.gui.TElement;
import com.thecsdev.commonmc.api.client.gui.panel.TPanelElement;
import com.thecsdev.commonmc.api.client.gui.screen.TScreen;
import com.thecsdev.commonmc.client.mixin.hooks.AccessorGameRenderer;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_1041;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11228;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3675;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TGuiUtils {
    private static final Random RNG = new Random();

    private TGuiUtils() {
    }

    public static final void playGuiButtonClickSound() {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
    }

    public static final void playGuiHoverSound() {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)((class_3414)class_3417.field_15204.comp_349()), (float)1.8f, (float)0.05f));
    }

    public static final void playGuiTypingSound() {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)((class_3414)class_3417.field_15204.comp_349()), (float)(1.0f + RNG.nextFloat() * 0.3f), (float)0.05f));
    }

    public static final class_11228 getGuiRenderer(class_310 client) {
        return ((AccessorGameRenderer)client.field_1773).getGuiRenderer();
    }

    public static final Bounds2i getScreenBounds() {
        class_1041 window = class_310.method_1551().method_22683();
        return new Bounds2i(0, 0, window.method_4486(), window.method_4502());
    }

    public static final boolean isKeyDown(int keyCode) {
        return class_3675.method_15987((class_1041)class_310.method_1551().method_22683(), (int)keyCode);
    }

    public static final boolean isShiftDown() {
        return TGuiUtils.isKeyDown(340) || TGuiUtils.isKeyDown(344);
    }

    public static final int calcMaxLineWidth(@NotNull class_2561 text, @NotNull class_327 font) throws NullPointerException {
        String[] lines = text.getString().replace("\r\n", "\n").split("\n");
        int maxWidth = 0;
        for (String line : lines) {
            maxWidth = Math.max(font.method_1727(line), maxWidth);
        }
        return maxWidth;
    }

    public static final int calcMaxWidth(@NotNull Iterable<TElement> elements) throws NullPointerException {
        int maxW = 0;
        for (TElement el : elements) {
            maxW = Math.max(el.getBounds().width, maxW);
        }
        return maxW;
    }

    public static final boolean isAncestor(@Nullable TElement child, @NotNull TElement candidateAncestor) throws NullPointerException {
        Objects.requireNonNull(candidateAncestor);
        if (child == null) {
            return false;
        }
        return child.findParent(p -> p == candidateAncestor).isPresent();
    }

    @Nullable
    public static final TElement previousFocusableTElement(TElement target) throws NullPointerException {
        return TGuiUtils.previousFocusableTElement(target, false);
    }

    @Nullable
    public static final TElement previousFocusableTElement(TElement target, boolean underflow) throws NullPointerException {
        TElement root = Objects.requireNonNull(target).findParent(el -> el.getParent() == null).orElse(null);
        if (root == null) {
            root = target;
        }
        ArrayList hierarchy = new ArrayList((int)((float)root.size() * 1.5f));
        root.forEachVisible(child -> {
            if (child.isFocusable() || child == target) {
                hierarchy.add(child);
            }
        }, true);
        if (hierarchy.isEmpty()) {
            return null;
        }
        int targetIndex = hierarchy.indexOf(target);
        if (targetIndex - 1 < 0) {
            return underflow ? (TElement)hierarchy.getLast() : null;
        }
        return (TElement)hierarchy.get(targetIndex - 1);
    }

    @Nullable
    public static final TElement nextFocusableTElement(TElement target) throws NullPointerException {
        return TGuiUtils.nextFocusableTElement(target, false);
    }

    @Nullable
    public static final TElement nextFocusableTElement(TElement target, boolean overflow) throws NullPointerException {
        TElement root = Objects.requireNonNull(target).findParent(el -> el.getParent() == null).orElse(null);
        if (root == null) {
            root = target;
        }
        ArrayList hierarchy = new ArrayList((int)((float)root.size() * 1.5f));
        root.forEachVisible(child -> {
            if (child.isFocusable() || child == target) {
                hierarchy.add(child);
            }
        }, true);
        if (hierarchy.isEmpty()) {
            return null;
        }
        int targetIndex = hierarchy.indexOf(target);
        if (targetIndex + 1 >= hierarchy.size()) {
            return overflow ? (TElement)hierarchy.getFirst() : null;
        }
        return (TElement)hierarchy.get(targetIndex + 1);
    }

    @Contract(value="null -> false; _ -> _")
    public static final boolean scrollToElement(@Nullable TElement target) {
        if (target == null) {
            return false;
        }
        TScreen screen = target.screenProperty().get();
        if (screen == null) {
            return false;
        }
        TPanelElement panel = target.findParent(p -> p instanceof TPanelElement).orElse(null);
        if (panel == null) {
            return screen.getBounds().contains(target.getBounds());
        }
        Bounds2i pbb = panel.getBounds();
        Bounds2i tbb = target.getBounds();
        int dX = 0;
        int dY = 0;
        if (!pbb.contains(tbb)) {
            if (tbb.width <= pbb.width && tbb.height <= pbb.height) {
                if (tbb.x < pbb.x) {
                    dX = tbb.x - pbb.x;
                } else if (tbb.endX > pbb.endX) {
                    dX = tbb.endX - pbb.endX;
                }
                if (tbb.y < pbb.y) {
                    dY = tbb.y - pbb.y;
                } else if (tbb.endY > pbb.endY) {
                    dY = tbb.endY - pbb.endY;
                }
            } else if (tbb.width > pbb.width) {
                if (tbb.y < pbb.y) {
                    dY = tbb.y - pbb.y;
                } else if (tbb.endY > pbb.endY) {
                    dY = tbb.endY - pbb.endY;
                }
            } else if (tbb.x < pbb.x) {
                dX = tbb.x - pbb.x;
            } else if (tbb.endX > pbb.endX) {
                dX = tbb.endX - pbb.endX;
            }
        }
        if (dX != 0 || dY != 0) {
            panel.scroll(-dX, -dY);
        }
        return TGuiUtils.scrollToElement(panel);
    }

    public static final void keepElementWithinBounds(@NotNull TElement target, @NotNull Bounds2i bounds) throws NullPointerException {
        Objects.requireNonNull(target);
        Objects.requireNonNull(bounds);
        Bounds2i bb = target.getBounds();
        int dX = 0;
        int dY = 0;
        if (bb.endY > bounds.endY) {
            dY = bounds.endY - bb.endY;
        }
        if (bb.y + dY < bounds.y) {
            dY += bounds.y - (bb.y + dY);
        }
        if (bb.endX > bounds.endX) {
            dX = bounds.endX - bb.endX;
        }
        if (bb.x + dX < bounds.x) {
            dX += bounds.x - (bb.x + dX);
        }
        if (dX != 0 || dY != 0) {
            target.move(dX, dY);
        }
    }
}

