/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.commonmc.api.client.gui.util;

import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public final class TInputContext {
    private final InputType inputType;
    @Nullable
    private final Integer keyCode;
    @Nullable
    private final Integer scanCode;
    @Nullable
    private final Integer keyModifiers;
    @Nullable
    private final Character character;
    @Nullable
    private final Double mouseX;
    @Nullable
    private final Double mouseY;
    @Nullable
    private final Integer mouseButton;
    @Nullable
    private final Double scrollX;
    @Nullable
    private final Double scrollY;
    @Nullable
    private final Double mouseDeltaX;
    @Nullable
    private final Double mouseDeltaY;

    private TInputContext(InputType inputType, @Nullable Integer keyCode, @Nullable Integer scanCode, @Nullable Integer keyModifiers, @Nullable Character character, @Nullable Double mouseX, @Nullable Double mouseY, @Nullable Integer mouseButton, @Nullable Double scrollX, @Nullable Double scrollY, @Nullable Double mouseDeltaX, @Nullable Double mouseDeltaY) {
        this.inputType = Objects.requireNonNull(inputType);
        this.keyCode = keyCode;
        this.scanCode = scanCode;
        this.keyModifiers = keyModifiers;
        this.character = character;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.mouseButton = mouseButton;
        this.scrollX = scrollX;
        this.scrollY = scrollY;
        this.mouseDeltaX = mouseDeltaX;
        this.mouseDeltaY = mouseDeltaY;
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.inputType, this.keyCode, this.scanCode, this.keyModifiers, this.character, this.mouseX, this.mouseY, this.mouseButton, this.scrollX, this.scrollY, this.mouseDeltaX, this.mouseDeltaY});
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TInputContext) {
            TInputContext other = (TInputContext)obj;
            return Objects.equals((Object)this.inputType, (Object)other.inputType) && Objects.equals(this.keyCode, other.keyCode) && Objects.equals(this.scanCode, other.scanCode) && Objects.equals(this.keyModifiers, other.keyModifiers) && Objects.equals(this.character, other.character) && Objects.equals(this.mouseX, other.mouseX) && Objects.equals(this.mouseY, other.mouseY) && Objects.equals(this.mouseButton, other.mouseButton) && Objects.equals(this.scrollX, other.scrollX) && Objects.equals(this.scrollY, other.scrollY) && Objects.equals(this.mouseDeltaX, other.mouseDeltaX) && Objects.equals(this.mouseDeltaY, other.mouseDeltaY);
        }
        return false;
    }

    public static final TInputContext ofKeyPress(int keyCode, int scanCode, int modifiers) {
        return new TInputContext(InputType.KEY_PRESS, keyCode, scanCode, modifiers, null, null, null, null, null, null, null, null);
    }

    public static final TInputContext ofKeyRelease(int keyCode, int scanCode, int modifiers) {
        return new TInputContext(InputType.KEY_RELEASE, keyCode, scanCode, modifiers, null, null, null, null, null, null, null, null);
    }

    public static final TInputContext ofCharType(char character, int modifiers) {
        return new TInputContext(InputType.CHAR_TYPE, null, null, modifiers, Character.valueOf(character), null, null, null, null, null, null, null);
    }

    public static final TInputContext ofMousePress(double mouseX, double mouseY, int button) {
        return new TInputContext(InputType.MOUSE_PRESS, null, null, null, null, mouseX, mouseY, button, null, null, null, null);
    }

    public static final TInputContext ofMouseRelease(double mouseX, double mouseY, int button) {
        return new TInputContext(InputType.MOUSE_RELEASE, null, null, null, null, mouseX, mouseY, button, null, null, null, null);
    }

    public static final TInputContext ofMouseMove(double mouseX, double mouseY) {
        return new TInputContext(InputType.MOUSE_MOVE, null, null, null, null, mouseX, mouseY, null, null, null, null, null);
    }

    public static final TInputContext ofMouseScroll(double mouseX, double mouseY, double scrollX, double scrollY) {
        return new TInputContext(InputType.MOUSE_SCROLL, null, null, null, null, mouseX, mouseY, null, scrollX, scrollY, null, null);
    }

    public static final TInputContext ofMouseDrag(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return new TInputContext(InputType.MOUSE_DRAG, null, null, null, null, mouseX, mouseY, button, null, null, deltaX, deltaY);
    }

    public final InputType getInputType() {
        return this.inputType;
    }

    @Nullable
    public final Integer getKeyCode() {
        return this.keyCode;
    }

    @Nullable
    public final Integer getScanCode() {
        return this.scanCode;
    }

    @Nullable
    public final Integer getKeyModifiers() {
        return this.keyModifiers;
    }

    @Nullable
    public final Character getCharacter() {
        return this.character;
    }

    @Nullable
    public final Double getMouseX() {
        return this.mouseX;
    }

    @Nullable
    public final Double getMouseY() {
        return this.mouseY;
    }

    @Nullable
    public final Integer getMouseButton() {
        return this.mouseButton;
    }

    @Nullable
    public final Double getScrollX() {
        return this.scrollX;
    }

    @Nullable
    public final Double getScrollY() {
        return this.scrollY;
    }

    @Nullable
    public final Double getMouseDeltaX() {
        return this.mouseDeltaX;
    }

    @Nullable
    public final Double getMouseDeltaY() {
        return this.mouseDeltaY;
    }

    public static enum InputType {
        KEY_PRESS,
        KEY_RELEASE,
        CHAR_TYPE,
        MOUSE_PRESS,
        MOUSE_RELEASE,
        MOUSE_MOVE,
        MOUSE_SCROLL,
        MOUSE_DRAG;


        public final boolean isKey() {
            return this == KEY_PRESS || this == KEY_RELEASE;
        }

        public final boolean isMouse() {
            return this == MOUSE_PRESS || this == MOUSE_RELEASE || this == MOUSE_MOVE || this == MOUSE_SCROLL || this == MOUSE_DRAG;
        }
    }

    public static enum InputDiscoveryPhase {
        BROADCAST,
        PREEMPT,
        MAIN;

    }
}

