/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.commonmc.api.client.gui.widget;

import com.thecsdev.common.math.Bounds2i;
import com.thecsdev.common.properties.IntegerProperty;
import com.thecsdev.common.util.annotations.Virtual;
import com.thecsdev.common.util.enumerations.CompassDirection;
import com.thecsdev.commonmc.api.client.gui.label.TLabelElement;
import com.thecsdev.commonmc.api.client.gui.render.TGuiGraphics;
import com.thecsdev.commonmc.api.client.gui.widget.TClickableWidget;
import org.jetbrains.annotations.NotNull;

@Virtual
public class TButtonWidget
extends TClickableWidget {
    public static final int LBL_PAD_X = 5;
    public static final int LBL_PAD_Y = 3;
    private final TLabelElement label = new TLabelElement();

    public TButtonWidget() {
        this.boundsProperty().addChangeListener((p, o, n) -> {
            if (!o.hasSameSize((Bounds2i)n) && this.getParent() != null) {
                this.clearAndInit();
            }
        });
        this.label.textAlignmentProperty().set(CompassDirection.CENTER, TButtonWidget.class);
        this.label.wrapTextProperty().set(false, TButtonWidget.class);
    }

    public final TLabelElement getLabel() {
        return this.label;
    }

    @Override
    @Virtual
    protected void initCallback() {
        Bounds2i bb = this.getBounds();
        this.label.setBounds(bb.add(5, 3, -10, -6));
        this.add(this.label);
    }

    @Override
    @Virtual
    public void renderCallback(@NotNull TGuiGraphics pencil) {
        Bounds2i bb = this.getBounds();
        pencil.drawButton(bb.x, bb.y, bb.width, bb.height, -1, this.isFocusable(), this.isHoveredOrFocused());
    }

    @Virtual
    public static class Paintable
    extends TButtonWidget {
        private final IntegerProperty background = new IntegerProperty(0x50000000);
        private final IntegerProperty outline = new IntegerProperty(0x50FFFFFF);
        private final IntegerProperty outlineFocused = new IntegerProperty(-5570561);

        public Paintable() {
        }

        public Paintable(int backgroundColor) {
            this.background.getHandle().set(backgroundColor);
        }

        public Paintable(int backgroundColor, int outlineColor) {
            this.background.getHandle().set(backgroundColor);
            this.outline.getHandle().set(outlineColor);
        }

        public Paintable(int backgroundColor, int outlineColor, int focusOutlineColor) {
            this.background.getHandle().set(backgroundColor);
            this.outline.getHandle().set(outlineColor);
            this.outlineFocused.getHandle().set(focusOutlineColor);
        }

        public final IntegerProperty backgroundColorProperty() {
            return this.background;
        }

        public final IntegerProperty outlineColorProperty() {
            return this.outline;
        }

        public final IntegerProperty focusedOutlineColorProperty() {
            return this.outlineFocused;
        }

        @Override
        public final void renderCallback(@NotNull TGuiGraphics pencil) {
            Bounds2i bb = this.getBounds();
            pencil.fillColor(bb.x, bb.y, bb.width, bb.height, this.background.getI());
        }

        @Override
        public final void postRenderCallback(@NotNull TGuiGraphics pencil) {
            Bounds2i bb = this.getBounds();
            pencil.drawOutlineIn(bb.x, bb.y, bb.width, bb.height, this.isHoveredOrFocused() ? this.outlineFocused.getI() : this.outline.getI());
            super.postRenderCallback(pencil);
        }
    }

    @Virtual
    public static class Transparent
    extends TButtonWidget {
        @Override
        @Virtual
        public void renderCallback(@NotNull TGuiGraphics pencil) {
            if (!this.isHoveredOrFocused()) {
                return;
            }
            Bounds2i bb = this.getBounds();
            pencil.drawOutlineIn(bb.x, bb.y, bb.width, bb.height, this.isHovered() ? 0x50FFFFFF : -5570561);
        }
    }

    @Virtual
    public static class Flat
    extends TButtonWidget {
        @Override
        @Virtual
        public void renderCallback(@NotNull TGuiGraphics pencil) {
            Bounds2i bb = this.getBounds();
            pencil.fillColor(bb.x, bb.y, bb.width, bb.height, 0x50000000);
            pencil.drawOutlineIn(bb.x, bb.y, bb.width, bb.height, this.isHoveredOrFocused() ? -5570561 : 0x50FFFFFF);
        }
    }
}

