/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.commonmc.api.client.gui.widget;

import com.thecsdev.common.math.Bounds2i;
import com.thecsdev.common.properties.BooleanProperty;
import com.thecsdev.common.util.annotations.Virtual;
import com.thecsdev.commonmc.api.client.gui.TElement;
import com.thecsdev.commonmc.api.client.gui.render.TGuiGraphics;
import com.thecsdev.commonmc.api.client.gui.util.CursorType;
import com.thecsdev.commonmc.api.client.gui.util.TGuiUtils;
import com.thecsdev.commonmc.api.client.gui.util.TInputContext;
import dev.architectury.event.Event;
import dev.architectury.event.EventFactory;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

@Virtual
public class TClickableWidget
extends TElement {
    private final BooleanProperty enabled = new BooleanProperty(true);
    private final BooleanProperty pressed = new BooleanProperty(false);
    public final Event<Consumer<TClickableWidget>> eClicked = EventFactory.createLoop((Object[])new Consumer[0]);
    protected static final Consumer<TClickableWidget> ONCLICK_SOUND = __ -> TGuiUtils.playGuiButtonClickSound();

    public TClickableWidget() {
        super.focusableProperty().set(true, TClickableWidget.class);
        this.eClicked.register(ONCLICK_SOUND);
    }

    public final BooleanProperty enabledProperty() {
        return this.enabled;
    }

    public final BooleanProperty pressedProperty() {
        return this.pressed;
    }

    public final void click() {
        this.clickCallback();
        ((Consumer)this.eClicked.invoker()).accept(this);
    }

    @Virtual
    protected void clickCallback() {
    }

    @Override
    @Virtual
    @NotNull
    public CursorType getCursor() {
        return this.isFocusable() ? CursorType.POINTING_HAND : CursorType.NOT_ALLOWED;
    }

    @Override
    @Virtual
    public boolean isFocusable() {
        return super.isFocusable() && this.enabled.getZ();
    }

    @Override
    @Virtual
    protected void hoverGainedCallback() {
        if (this.isFocusable()) {
            TGuiUtils.playGuiHoverSound();
        }
    }

    @Override
    @Virtual
    protected void dragStartCallback() {
        this.pressed.set(true, TClickableWidget.class);
    }

    @Override
    @Virtual
    protected void dragEndCallback() {
        this.pressed.set(false, TClickableWidget.class);
    }

    @Override
    @Virtual
    protected void focusLostCallback() {
        this.pressed.set(false, TClickableWidget.class);
    }

    @Override
    @Virtual
    public boolean inputCallback(@NotNull TInputContext.InputDiscoveryPhase phase, @NotNull TInputContext context) {
        if (phase != TInputContext.InputDiscoveryPhase.MAIN || !this.isFocusable()) {
            return false;
        }
        switch (context.getInputType()) {
            case MOUSE_PRESS: {
                if (context.getMouseButton() != 0) break;
                return true;
            }
            case MOUSE_RELEASE: {
                if (context.getMouseButton() != 0) break;
                if (this.isHovered()) {
                    this.click();
                }
                return true;
            }
            case KEY_PRESS: {
                int kc = context.getKeyCode();
                if (kc != 257 && kc != 335) break;
                this.pressed.set(true, TClickableWidget.class);
                this.click();
                return true;
            }
            case KEY_RELEASE: {
                int kc = context.getKeyCode();
                if (kc != 257 && kc != 335) break;
                this.pressed.set(false, TClickableWidget.class);
                return true;
            }
        }
        return false;
    }

    @Override
    @Virtual
    public void postRenderCallback(@NotNull TGuiGraphics pencil) {
        Bounds2i bb = this.getBounds();
        if (((Boolean)this.pressedProperty().get()).booleanValue()) {
            pencil.fillColor(bb.x, bb.y, bb.width, bb.height, 0x33FFFFFF);
        }
    }
}

