/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.commonmc.api.client.gui.widget;

import com.thecsdev.common.math.Bounds2i;
import com.thecsdev.common.properties.IChangeListener;
import com.thecsdev.common.properties.ObjectProperty;
import com.thecsdev.common.util.annotations.Virtual;
import com.thecsdev.common.util.enumerations.CompassDirection;
import com.thecsdev.commonmc.api.client.gui.TElement;
import com.thecsdev.commonmc.api.client.gui.ctxmenu.TContextMenu;
import com.thecsdev.commonmc.api.client.gui.label.TLabelElement;
import com.thecsdev.commonmc.api.client.gui.misc.TTextureElement;
import com.thecsdev.commonmc.api.client.gui.panel.TPanelElement;
import com.thecsdev.commonmc.api.client.gui.render.TGuiGraphics;
import com.thecsdev.commonmc.api.client.gui.screen.TScreen;
import com.thecsdev.commonmc.api.client.gui.widget.TButtonWidget;
import com.thecsdev.commonmc.api.client.gui.widget.TScrollBarWidget;
import com.thecsdev.commonmc.resources.TCDCLang;
import com.thecsdev.commonmc.resources.TCDCSprites;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Virtual
public class TDropdownWidget<E extends Entry>
extends TButtonWidget {
    private static final class_2960[] ICONS = new class_2960[]{TCDCSprites.gui_widget_dropdownCollapsed(), TCDCSprites.gui_widget_dropdownExpanded()};
    private final ObjectProperty<E> selectedEntry = new ObjectProperty();
    private final Collection<E> entries = new LinkedHashSet();
    private final TTextureElement icon = new TTextureElement();

    public TDropdownWidget() {
        this(null);
    }

    public TDropdownWidget(@Nullable E selectedEntry) {
        this.selectedEntry.getHandle().set(selectedEntry);
        this.selectedEntry.addChangeListener((p, o, n) -> {
            if (n == null) {
                this.getLabel().setText((class_2561)TCDCLang.gui_dropdown_defaultLabel());
            } else {
                this.getLabel().setText(n.getDisplayName());
            }
        });
        this.getLabel().textAlignmentProperty().set(CompassDirection.WEST, TDropdownWidget.class);
        this.getLabel().setText((class_2561)(selectedEntry != null ? selectedEntry.getDisplayName() : TCDCLang.gui_dropdown_defaultLabel()));
        this.icon.modeProperty().set(TTextureElement.Mode.GUI_SPRITE, TDropdownWidget.class);
        this.icon.textureProperty().set(ICONS[0], TDropdownWidget.class);
    }

    public final ObjectProperty<E> selectedEntryProperty() {
        return this.selectedEntry;
    }

    public final Collection<E> getEntries() {
        return this.entries;
    }

    @Override
    @Virtual
    protected void initCallback() {
        super.initCallback();
        Bounds2i bb = this.getBounds();
        int size = (int)Math.min((double)Math.min(bb.width, bb.height) * 0.6, 20.0);
        this.icon.setBounds(bb.endX - size - 5, bb.y + bb.height / 2 - size / 2, size, size);
        this.add(this.icon);
    }

    @Override
    protected final void clickCallback() {
        super.clickCallback();
        TScreen screen = this.screenProperty().get();
        if (screen == null) {
            return;
        }
        TDropdownElement dd = new TDropdownElement();
        dd.boundsProperty().addFilter(n -> {
            Bounds2i sbb = screen.getBounds();
            int dX = n.endX > sbb.endX ? sbb.endX - n.endX : 0;
            int dY = n.endY > sbb.endY ? sbb.endY - n.endY : 0;
            return dX == 0 && dY == 0 ? n : new Bounds2i(n.x + dX, n.y + dY, n.width, n.height);
        }, TDropdownWidget.class);
        screen.add(dd);
        dd.clearAndInit();
    }

    public static interface Entry {
        @NotNull
        public class_2561 getDisplayName();
    }

    private final class TDropdownElement
    extends TContextMenu {
        public TDropdownElement() {
            IChangeListener<TElement> cl_focus = (p, o, n) -> {
                if (this.isFocusAncestor()) {
                    return;
                }
                this.remove();
                p.set(TDropdownWidget.this, TDropdownElement.class);
            };
            this.screenProperty().addChangeListener((p, o, n) -> {
                if (o != null) {
                    o.focusedElementProperty().removeChangeListener(cl_focus);
                }
                if (n != null) {
                    n.focusedElementProperty().addChangeListener(cl_focus);
                }
            });
            this.screenProperty().addChangeListener((p, o, n) -> TDropdownWidget.this.icon.textureProperty().set(n == null ? ICONS[0] : ICONS[1], TDropdownElement.class));
        }

        @Override
        protected final void initCallback() {
            TPanelElement.Transparent panel = new TPanelElement.Transparent();
            panel.scrollPaddingProperty().set(0, TDropdownElement.class);
            int entryMaxW = 0;
            for (Entry entry : TDropdownWidget.this.entries) {
                Objects.requireNonNull(entry, "Found a 'null' entry in a dropdown widget");
                TButtonWidget.Transparent btn = new TButtonWidget.Transparent(this){

                    @Override
                    public final void postRenderCallback(@NotNull TGuiGraphics pencil) {
                    }

                    @Override
                    public final void renderCallback(@NotNull TGuiGraphics pencil) {
                        if (!this.isHoveredOrFocused()) {
                            return;
                        }
                        Bounds2i bb = this.getBounds();
                        pencil.fillColor(bb.x, bb.y, bb.width, bb.height, -13224395);
                    }
                };
                TLabelElement lbl = btn.getLabel();
                lbl.textAlignmentProperty().set(CompassDirection.WEST, TDropdownElement.class);
                lbl.setText(entry.getDisplayName());
                entryMaxW = Math.max(lbl.fontProperty().get().method_27525((class_5348)lbl.textProperty().get()), entryMaxW);
                btn.eClicked.register(__ -> {
                    this.remove();
                    TDropdownWidget.this.selectedEntry.set(entry, TDropdownElement.class);
                });
                panel.add(btn);
            }
            entryMaxW += 10;
            int nextY = 0;
            int entryH = 15;
            for (TElement entry : panel) {
                entry.setBounds(0, nextY, entryMaxW, entryH);
                nextY += entryH;
            }
            int SCROLL_W = 8;
            Bounds2i dbb = TDropdownWidget.this.getBounds();
            Bounds2i pcbb = panel.getContentBounds();
            panel.setBounds(0, 0, Math.clamp((long)(dbb.width - 8), 100, 250), Math.clamp((long)pcbb.height, entryH, 100));
            dbb = TDropdownWidget.this.getBounds();
            Bounds2i pbb = panel.getBounds();
            this.setBounds(dbb.x, dbb.endY, pbb.width + 8, pbb.height + 8);
            this.addRel(panel);
            Bounds2i bb = this.getBounds();
            TScrollBarWidget.Flat scroll_v = new TScrollBarWidget.Flat(panel, TScrollBarWidget.ScrollDirection.VERTICAL);
            scroll_v.setBounds(bb.endX - 8, bb.y + 1, 7, bb.height - 8 - 1);
            this.add(scroll_v);
            TScrollBarWidget.Flat scroll_h = new TScrollBarWidget.Flat(panel, TScrollBarWidget.ScrollDirection.HORIZONTAL);
            scroll_h.setBounds(bb.x + 1, bb.endY - 8, bb.width - 8 - 1, 7);
            this.add(scroll_h);
            Bounds2i pbb2 = panel.getBounds();
            if (entryMaxW < pbb2.width) {
                int diff = pbb2.width - entryMaxW;
                for (TElement btn : panel) {
                    btn.setBounds(btn.getBounds().add(0, 0, diff, 0));
                }
            }
        }
    }

    public static final class SimpleEntry
    implements Entry {
        private final class_2561 displayName;

        public SimpleEntry(@NotNull class_2561 displayName) throws NullPointerException {
            this.displayName = Objects.requireNonNull(displayName);
        }

        @Override
        @NotNull
        public final class_2561 getDisplayName() {
            return this.displayName;
        }

        public final int hashCode() {
            return Objects.hash(this.displayName);
        }

        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SimpleEntry other = (SimpleEntry)obj;
            return Objects.equals(this.displayName, other.displayName);
        }
    }
}

