/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.commonmc.api.client.gui.widget;

import com.thecsdev.common.math.Bounds2i;
import com.thecsdev.common.math.Point2d;
import com.thecsdev.common.math.UDim2;
import com.thecsdev.common.properties.IChangeListener;
import com.thecsdev.common.properties.NotNullProperty;
import com.thecsdev.common.properties.ObjectProperty;
import com.thecsdev.common.util.annotations.Virtual;
import com.thecsdev.commonmc.api.client.gui.TElement;
import com.thecsdev.commonmc.api.client.gui.panel.TPanelElement;
import com.thecsdev.commonmc.api.client.gui.render.TGuiGraphics;
import com.thecsdev.commonmc.api.client.gui.util.TInputContext;
import com.thecsdev.commonmc.api.client.gui.widget.TSliderWidget;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Virtual
public class TScrollBarWidget
extends TSliderWidget {
    private final ObjectProperty<TPanelElement> panel = new ObjectProperty<Object>(null);
    private final NotNullProperty<ScrollDirection> direction = new NotNullProperty<ScrollDirection>(ScrollDirection.BIAXIAL);

    public TScrollBarWidget() {
        this.knobSizeProperty().setReadOnly(true, TScrollBarWidget.class);
        this.knobSizeProperty().setOwner(TScrollBarWidget.class, TScrollBarWidget.class);
        this.valueProperty().addFilter(in -> switch (this.direction.get().ordinal()) {
            case 0 -> new Point2d(in.x, 0.0);
            case 1 -> new Point2d(0.0, in.y);
            default -> in;
        }, TScrollBarWidget.class);
        this.valueProperty().addChangeListener((p, o, n) -> {
            TPanelElement panel = this.panel.get();
            if (panel == null) {
                return;
            }
            Point2d panelScrollAmount = panel.scrollAmountProperty().get();
            NotNullProperty<Point2d> notNullProperty = panel.scrollAmountProperty();
            notNullProperty.set(switch (this.direction.get().ordinal()) {
                case 0 -> new Point2d(n.x, panelScrollAmount.y);
                case 1 -> new Point2d(panelScrollAmount.x, n.y);
                default -> n;
            }, TScrollBarWidget.class);
        });
        Consumer<TElement> onPanelInit = __ -> this.refresh();
        IChangeListener<Point2d> onPanelScrollValueChange = (p, o, n) -> this._refreshValue();
        this.panel.addChangeListener((p, o, n) -> {
            if (o != null) {
                o.eInitialized.unregister((Object)onPanelInit);
                o.scrollAmountProperty().removeChangeListener(onPanelScrollValueChange);
            }
            if (n != null) {
                n.eInitialized.register((Object)onPanelInit);
                n.scrollAmountProperty().addChangeListener(onPanelScrollValueChange);
            }
        });
    }

    public TScrollBarWidget(@NotNull TPanelElement panel) {
        this();
        this.panel.set(panel, TScrollBarWidget.class);
    }

    public TScrollBarWidget(@NotNull TPanelElement panel, @NotNull ScrollDirection direction) {
        this();
        this.direction.set(direction, TScrollBarWidget.class);
        this.panel.set(panel, TScrollBarWidget.class);
    }

    public final void refresh() {
        this._refreshValue();
        this._refreshKnobSize();
    }

    @ApiStatus.Internal
    private final void _refreshValue() {
        if (this.pressedProperty().getZ()) {
            return;
        }
        TPanelElement panel = this.panel.get();
        if (panel == null) {
            return;
        }
        this.valueProperty().getHandle().set(this.valueProperty().applyFilters(panel.scrollAmountProperty().get()));
        this.refreshKnobQuietly();
    }

    @ApiStatus.Internal
    private final void _refreshKnobSize() {
        TPanelElement panel = this.panel.get();
        if (panel == null) {
            return;
        }
        Bounds2i pbb = panel.getBounds();
        Bounds2i pcbb = panel.getContentBounds();
        NotNullProperty<UDim2> notNullProperty = this.knobSizeProperty();
        notNullProperty.set(switch (this.direction.get().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> UDim2.fromScale((double)pbb.width / (double)pcbb.width, 1.0);
            case 1 -> UDim2.fromScale(1.0, (double)pbb.height / (double)pcbb.height);
            case 2 -> UDim2.fromScale((double)pbb.width / (double)pcbb.width, (double)pbb.height / (double)pcbb.height);
        }, TScrollBarWidget.class);
    }

    public final ObjectProperty<@Nullable TPanelElement> panelProperty() {
        return this.panel;
    }

    public final NotNullProperty<ScrollDirection> scrollDirectionProperty() {
        return this.direction;
    }

    @Override
    public final boolean inputCallback(@NotNull TInputContext.InputDiscoveryPhase phase, @NotNull TInputContext context) {
        TPanelElement panel;
        if (phase == TInputContext.InputDiscoveryPhase.MAIN && (context.getInputType() == TInputContext.InputType.MOUSE_SCROLL || context.getInputType() == TInputContext.InputType.KEY_PRESS) && (panel = this.panel.get()) != null) {
            return panel.inputCallback(phase, context);
        }
        return super.inputCallback(phase, context);
    }

    public static enum ScrollDirection {
        HORIZONTAL,
        VERTICAL,
        BIAXIAL;

    }

    @Virtual
    public static class Flat
    extends TScrollBarWidget {
        public Flat() {
        }

        public Flat(@NotNull TPanelElement panel) {
            super(panel);
        }

        public Flat(@NotNull TPanelElement panel, @NotNull ScrollDirection direction) {
            super(panel, direction);
        }

        @Override
        @Virtual
        public void renderBackground(@NotNull TGuiGraphics pencil) {
            Bounds2i bb = this.getBounds();
            pencil.fillColor(bb.x, bb.y, bb.width, bb.height, 0x50000000);
            pencil.drawOutlineIn(bb.x, bb.y, bb.width, bb.height, -16777216);
        }

        @Override
        @Virtual
        public void renderKnob(@NotNull TGuiGraphics pencil, @NotNull Bounds2i kbb) {
            pencil.fillColor(kbb.x, kbb.y, kbb.width, kbb.height, this.isHoveredOrFocused() ? 0x6EFFFFFF : 0x42FFFFFF);
        }
    }
}

