/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.commonmc.api.client.gui.widget;

import com.thecsdev.common.math.Bounds2i;
import com.thecsdev.common.math.Point2d;
import com.thecsdev.common.math.UDim2;
import com.thecsdev.common.properties.IChangeListener;
import com.thecsdev.common.properties.NotNullProperty;
import com.thecsdev.common.util.annotations.Virtual;
import com.thecsdev.commonmc.api.client.gui.render.TGuiGraphics;
import com.thecsdev.commonmc.api.client.gui.util.TGuiUtils;
import com.thecsdev.commonmc.api.client.gui.util.TInputContext;
import com.thecsdev.commonmc.api.client.gui.widget.TButtonWidget;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Virtual
public class TSliderWidget
extends TButtonWidget {
    private final NotNullProperty<Point2d> value = new NotNullProperty<Point2d>(Point2d.ZERO);
    private final NotNullProperty<UDim2> knobSize = new NotNullProperty<UDim2>(UDim2.ZERO);
    @ApiStatus.Internal
    private final NotNullProperty<Bounds2i> knobBounds = new NotNullProperty<Bounds2i>(Bounds2i.ZERO);

    public TSliderWidget(@NotNull Point2d value) {
        this();
        this.value.getHandle().set(value);
    }

    public TSliderWidget() {
        this.eClicked.unregister((Object)ONCLICK_SOUND);
        this.pressedProperty().addChangeListener((p, o, n) -> {
            if (!n.booleanValue()) {
                TGuiUtils.playGuiButtonClickSound();
            }
        });
        this.value.addFilter(Point2d::clamp01, TSliderWidget.class);
        this.value.addChangeListener((p, o, n) -> this.knobBounds.getHandle().set(this.computeKnobFromValue()));
        this.knobBounds.addFilter(hbb -> {
            Bounds2i sbb = this.getBounds();
            int kbbW = Math.clamp((long)hbb.width, 0, sbb.width);
            int kbbH = Math.clamp((long)hbb.height, 0, sbb.height);
            return new Bounds2i(Math.clamp((long)hbb.x, sbb.x, sbb.endX - kbbW), Math.clamp((long)hbb.y, sbb.y, sbb.endY - kbbH), kbbW, kbbH);
        }, TSliderWidget.class);
        this.knobBounds.addChangeListener((p, o, n) -> {
            if (!this.pressedProperty().getZ() || !o.hasSameSize((Bounds2i)n)) {
                return;
            }
            this.value.set(this.computeValueFromKnob(), TSliderWidget.class);
        });
        IChangeListener<Object> cl_rkbq = (p, o, n) -> this.refreshKnobQuietly();
        this.boundsProperty().addChangeListener(cl_rkbq);
        this.knobSize.addChangeListener(cl_rkbq);
        this.refreshKnobQuietly();
    }

    @ApiStatus.Internal
    protected final void refreshKnobQuietly() {
        Bounds2i sbb = this.getBounds();
        Bounds2i kbb = this.knobBounds.get();
        UDim2 siz = this.knobSize.get();
        this.knobBounds.getHandle().set(new Bounds2i(kbb.x, kbb.y, Math.min(Math.max(siz.x.computeI(sbb.width), 10), sbb.width), Math.min(Math.max(siz.y.computeI(sbb.height), 10), sbb.height)));
        this.knobBounds.getHandle().set(this.computeKnobFromValue());
    }

    public final NotNullProperty<Point2d> valueProperty() {
        return this.value;
    }

    public final NotNullProperty<UDim2> knobSizeProperty() {
        return this.knobSize;
    }

    @ApiStatus.Internal
    @NotNull
    private final Point2d computeValueFromKnob() {
        Bounds2i sbb = this.getBounds();
        Bounds2i kbb = this.knobBounds.get();
        Point2d val = this.value.get();
        double cX = Math.max(kbb.x - sbb.x, 0);
        double cY = Math.max(kbb.y - sbb.y, 0);
        double cW = Math.max(sbb.width - kbb.width, 1);
        double cH = Math.max(sbb.height - kbb.height, 1);
        return new Point2d(kbb.width >= sbb.width ? val.x : cX / cW, kbb.height >= sbb.height ? val.y : cY / cH);
    }

    @ApiStatus.Internal
    @NotNull
    private final Bounds2i computeKnobFromValue() {
        Point2d val = this.value.get();
        Bounds2i sbb = this.getBounds();
        Bounds2i kbb = this.knobBounds.get();
        int cW = sbb.width - kbb.width;
        int cH = sbb.height - kbb.height;
        int cX = sbb.x + (int)((double)cW * val.x);
        int cY = sbb.y + (int)((double)cH * val.y);
        return new Bounds2i(cX, cY, kbb.width, kbb.height);
    }

    @Override
    public final void renderCallback(@NotNull TGuiGraphics pencil) {
        this.renderBackground(pencil);
        this.renderKnob(pencil, this.knobBounds.get());
    }

    @Override
    @Virtual
    public void postRenderCallback(@NotNull TGuiGraphics pencil) {
    }

    @Virtual
    public void renderBackground(@NotNull TGuiGraphics pencil) {
        Bounds2i sbb = this.getBounds();
        pencil.drawButton(sbb.x, sbb.y, sbb.width, sbb.height, -1, false, false);
    }

    @Virtual
    public void renderKnob(@NotNull TGuiGraphics pencil, @NotNull Bounds2i kbb) {
        boolean enabled = this.enabledProperty().getZ();
        boolean highlighted = this.isHoveredOrFocused();
        Bounds2i bb = this.getBounds();
        pencil.drawButton(bb.x, bb.y, kbb.endX - bb.x, kbb.endY - bb.y, 0x75505050, enabled, highlighted);
        pencil.drawButton(kbb.x, kbb.y, kbb.width, kbb.height, -1, enabled, highlighted);
    }

    @Override
    @ApiStatus.NonExtendable
    public boolean inputCallback(@NotNull TInputContext.InputDiscoveryPhase phase, @NotNull TInputContext context) {
        if (super.inputCallback(phase, context)) {
            return true;
        }
        if (phase != TInputContext.InputDiscoveryPhase.MAIN || !this.isFocusable()) {
            return false;
        }
        if (context.getInputType() == TInputContext.InputType.MOUSE_DRAG && this.pressedProperty().getZ() && context.getMouseButton() == 0) {
            Bounds2i kbb = this.knobBounds.get();
            int w2 = kbb.width / 2;
            int h2 = kbb.height / 2;
            this.knobBounds.set(new Bounds2i((int)(context.getMouseX() - (double)w2), (int)(context.getMouseY() - (double)h2), kbb.width, kbb.height), TSliderWidget.class);
            return true;
        }
        if (context.getInputType() == TInputContext.InputType.KEY_PRESS) {
            double sensitivity = 0.05;
            double dX = 0.0;
            double dY = 0.0;
            switch (context.getKeyCode()) {
                case 263: {
                    dX -= 0.05;
                    break;
                }
                case 262: {
                    dX += 0.05;
                    break;
                }
                case 265: {
                    dY -= 0.05;
                    break;
                }
                case 264: {
                    dY += 0.05;
                    break;
                }
            }
            if (dX != 0.0 || dY != 0.0) {
                this.value.set(this.value.get().add(dX, dY), TSliderWidget.class);
                return true;
            }
        } else if (context.getInputType() == TInputContext.InputType.MOUSE_SCROLL) {
            double sensitivity = 0.05;
            double dX = 0.05 * context.getScrollX();
            double dY = -0.05 * context.getScrollY();
            if (dX != 0.0 || dY != 0.0) {
                this.value.set(this.value.get().add(dX, dY), TSliderWidget.class);
                return true;
            }
        }
        return false;
    }

    @Virtual
    public static class Flat
    extends TSliderWidget {
        @Override
        public final void renderBackground(@NotNull TGuiGraphics pencil) {
            Bounds2i bb = this.getBounds();
            pencil.fillColor(bb.x, bb.y, bb.width, bb.height, 0x50000000);
            pencil.drawOutlineIn(bb.x, bb.y, bb.width, bb.height, -16777216);
        }

        @Override
        public final void renderKnob(@NotNull TGuiGraphics pencil, @NotNull Bounds2i kbb) {
            pencil.fillColor(kbb.x, kbb.y, kbb.width, kbb.height, this.isHoveredOrFocused() ? 0x6EFFFFFF : 0x32FFFFFF);
        }
    }
}

