/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.commonmc.api.client.gui.widget.stats;

import com.thecsdev.common.properties.IChangeListener;
import com.thecsdev.common.properties.ObjectProperty;
import com.thecsdev.commonmc.api.client.gui.TElement;
import com.thecsdev.commonmc.api.client.gui.tooltip.TTooltip;
import com.thecsdev.commonmc.api.client.gui.widget.stats.TTextualStatWidget;
import com.thecsdev.commonmc.api.stats.IStatsProvider;
import com.thecsdev.commonmc.api.stats.util.CustomStat;
import com.thecsdev.commonmc.api.stats.util.StatFormatterOverride;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TCustomStatWidget
extends TTextualStatWidget {
    private static final Function<TElement, @NotNull TElement> TOOLTIP = el -> {
        TCustomStatWidget csw = (TCustomStatWidget)el;
        CustomStat stat = csw.stat.get();
        Objects.requireNonNull(stat, "Stat value is missing while constructing tooltip.");
        return TTooltip.of(stat);
    };
    private final ObjectProperty<CustomStat> stat = new ObjectProperty();
    private final ObjectProperty<StatFormatterOverride> formatterOverride = new ObjectProperty();

    public TCustomStatWidget() {
        this(null);
    }

    public TCustomStatWidget(@NotNull class_2960 subject, @NotNull IStatsProvider provider) {
        this(new CustomStat(subject, provider));
    }

    public TCustomStatWidget(@Nullable CustomStat stat) {
        IChangeListener<Object> cl_update = (p, o, n) -> {
            if (this.getParent() != null) {
                this.onUpdate();
            }
        };
        this.stat.addChangeListener(cl_update);
        this.formatterOverride.addChangeListener(cl_update);
        this.stat.getHandle().set(stat);
    }

    @ApiStatus.Internal
    private final void onUpdate() {
        CustomStat stat = this.stat.get();
        if (stat != null) {
            this.getKeyLabel().textProperty().set(stat.getSubjectDisplayName(), TCustomStatWidget.class);
            this.getValueLabel().textProperty().set((class_2561)class_2561.method_43470((String)stat.getValueF(this.formatterOverride.get())), TCustomStatWidget.class);
            this.tooltipProperty().set(TOOLTIP, TCustomStatWidget.class);
        } else {
            this.getKeyLabel().textProperty().set((class_2561)class_2561.method_43470((String)"-"), TCustomStatWidget.class);
            this.getValueLabel().textProperty().set((class_2561)class_2561.method_43470((String)"-"), TCustomStatWidget.class);
            this.tooltipProperty().set(null, TCustomStatWidget.class);
        }
        this.invalidateTooltipCache();
    }

    @Override
    protected void initCallback() {
        super.initCallback();
        this.onUpdate();
    }

    public final ObjectProperty<CustomStat> statProperty() {
        return this.stat;
    }

    public final ObjectProperty<StatFormatterOverride> formatterOverrideProperty() {
        return this.formatterOverride;
    }
}

