/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.commonmc.api.client.gui.widget.stats;

import com.thecsdev.common.properties.BooleanProperty;
import com.thecsdev.common.properties.ObjectProperty;
import com.thecsdev.common.util.enumerations.CompassDirection;
import com.thecsdev.commonmc.api.client.gui.TElement;
import com.thecsdev.commonmc.api.client.gui.misc.TEntityElement;
import com.thecsdev.commonmc.api.client.gui.tooltip.TTooltip;
import com.thecsdev.commonmc.api.client.gui.widget.stats.TStatsWidget;
import com.thecsdev.commonmc.api.stats.IStatsProvider;
import com.thecsdev.commonmc.api.stats.util.EntityStats;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_1299;
import net.minecraft.class_2561;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TEntityStatsWidget
extends TStatsWidget {
    private static final Function<TElement, TElement> TOOLTIP = el -> {
        TEntityStatsWidget mstw = (TEntityStatsWidget)el;
        EntityStats stats = mstw.stats.get();
        Objects.requireNonNull(stats, "Stats value is missing while constructing tooltip.");
        return TTooltip.of(stats);
    };
    private final ObjectProperty<EntityStats> stats = new ObjectProperty();
    private final TEntityElement el_entity = new TEntityElement(class_1299.field_33456);

    public TEntityStatsWidget() {
        this(null);
    }

    public TEntityStatsWidget(@NotNull class_1299<?> subject, @NotNull IStatsProvider provider) {
        this(new EntityStats(subject, provider));
    }

    public TEntityStatsWidget(@Nullable EntityStats stats) {
        this.stats.addChangeListener((p, o, n) -> this.refresh());
        this.stats.getHandle().set(stats);
        this.el_entity.entityScaleProperty().set(0.7, TEntityStatsWidget.class);
        this.getLabel().textAlignmentProperty().set(CompassDirection.CENTER, TEntityStatsWidget.class);
        this.getLabel().wrapTextProperty().set(true, TEntityStatsWidget.class);
        this.getLabel().visibleProperty().set(false, TEntityStatsWidget.class);
        this.refresh();
    }

    @ApiStatus.Internal
    private final void refresh() {
        this.tooltipProperty().set(this.stats.get() != null ? TOOLTIP : null, TEntityStatsWidget.class);
        EntityStats stats = this.stats.get();
        this.el_entity.entityTypeProperty().set(stats != null ? (class_1299)stats.getSubject() : null, TEntityStatsWidget.class);
        this.getLabel().setText((class_2561)(stats != null ? stats.getSubjectDisplayName() : class_2561.method_43470((String)"-")));
    }

    public final ObjectProperty<EntityStats> statsProperty() {
        return this.stats;
    }

    public final BooleanProperty followsCursorProperty() {
        return this.el_entity.followsCursorProperty();
    }

    @Override
    protected final void initCallback() {
        this.el_entity.setBounds(this.getBounds());
        this.add(this.el_entity);
        this.getLabel().setBounds(this.getBounds());
        this.add(this.getLabel());
    }

    @Override
    protected final void tickCallback() {
        super.tickCallback();
        this.getLabel().visibleProperty().set(this.el_entity.getDisplayEntity() == null, TEntityStatsWidget.class);
    }
}

