/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.commonmc.api.client.gui.widget.stats;

import com.thecsdev.common.math.Bounds2i;
import com.thecsdev.common.properties.ObjectProperty;
import com.thecsdev.commonmc.api.client.gui.TElement;
import com.thecsdev.commonmc.api.client.gui.render.TGuiGraphics;
import com.thecsdev.commonmc.api.client.gui.tooltip.TTooltip;
import com.thecsdev.commonmc.api.client.gui.widget.stats.TStatsWidget;
import com.thecsdev.commonmc.api.stats.EmptyStatsProvider;
import com.thecsdev.commonmc.api.stats.IStatsProvider;
import com.thecsdev.commonmc.api.stats.util.ItemStats;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TItemStatsWidget
extends TStatsWidget {
    private static final Function<TElement, TElement> TOOLTIP = el -> {
        TItemStatsWidget isw = (TItemStatsWidget)el;
        ItemStats stats = isw.stats.get();
        Objects.requireNonNull(stats, "Stats value is missing while constructing tooltip.");
        return TTooltip.of(stats);
    };
    private final ObjectProperty<ItemStats> stats = new ObjectProperty();
    @Nullable
    private Bounds2i itemDrawBounds = null;
    @NotNull
    private class_1799 itemStack = class_1802.field_8162.method_7854();

    public TItemStatsWidget() {
        this(class_1802.field_8162, EmptyStatsProvider.INSTANCE);
    }

    public TItemStatsWidget(@NotNull class_1792 item, @NotNull IStatsProvider statsProvider) {
        this(new ItemStats(item, statsProvider));
    }

    public TItemStatsWidget(@Nullable ItemStats stats) {
        this.boundsProperty().addChangeListener((p, o, n) -> {
            this.itemDrawBounds = null;
        });
        this.stats.addChangeListener((p, o, n) -> {
            this.itemStack = n != null ? ((class_1792)n.getSubject()).method_7854() : class_1802.field_8162.method_7854();
            this.tooltipProperty().set(n != null ? TOOLTIP : null, TItemStatsWidget.class);
            this.invalidateTooltipCache();
        });
        this.stats.set(stats, TItemStatsWidget.class);
    }

    public final ObjectProperty<ItemStats> statsProperty() {
        return this.stats;
    }

    @Override
    public final void renderCallback(@NotNull TGuiGraphics pencil) {
        Bounds2i idb;
        super.renderCallback(pencil);
        Bounds2i bb = this.getBounds();
        Bounds2i bounds2i = idb = this.itemDrawBounds != null ? this.itemDrawBounds : (this.itemDrawBounds = new Bounds2i(bb.x + 3, bb.y + 3, bb.width - 6, bb.height - 6));
        if (!idb.isEmpty) {
            pencil.renderItem(this.itemStack, idb.x, idb.y, idb.width, idb.height);
        }
    }
}

