/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.commonmc.api.client.gui.widget.text;

import com.thecsdev.common.math.Bounds2i;
import com.thecsdev.common.properties.NotNullProperty;
import com.thecsdev.common.util.annotations.Virtual;
import com.thecsdev.common.util.enumerations.CompassDirection;
import com.thecsdev.commonmc.api.client.gui.label.TLabelElement;
import com.thecsdev.commonmc.api.client.gui.render.TGuiGraphics;
import com.thecsdev.commonmc.api.client.gui.util.CursorType;
import com.thecsdev.commonmc.api.client.gui.util.TGuiUtils;
import com.thecsdev.commonmc.api.client.gui.util.TInputContext;
import com.thecsdev.commonmc.api.client.gui.widget.TClickableWidget;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public final class TSimpleTextFieldWidget
extends TClickableWidget {
    private final NotNullProperty<class_327> font;
    private final NotNullProperty<class_2561> placeholder;
    private final NotNullProperty<String> text;
    private final TLabelElement lbl_placeholder;
    private final TLabelElement lbl_text;

    public TSimpleTextFieldWidget() {
        this.font = new NotNullProperty<class_327>(class_310.method_1551().field_1772);
        this.placeholder = new NotNullProperty<class_5250>(class_2561.method_43473());
        this.text = new NotNullProperty<String>("");
        this.lbl_placeholder = new TLabelElement();
        this.lbl_text = new TLabelElement();
        this.eClicked.unregister((Object)ONCLICK_SOUND);
        this.lbl_text.hoverableProperty().set(false, TSimpleTextFieldWidget.class);
        this.lbl_text.textAlignmentProperty().set(CompassDirection.WEST, TSimpleTextFieldWidget.class);
        this.lbl_placeholder.hoverableProperty().set(false, TSimpleTextFieldWidget.class);
        this.lbl_placeholder.textAlignmentProperty().set(CompassDirection.WEST, TSimpleTextFieldWidget.class);
        this.lbl_placeholder.textColorProperty().set(0x55FFFFFF, TSimpleTextFieldWidget.class);
        Runnable refresh_alignment = () -> {
            int textW = this.font.get().method_1727(this.text.get());
            this.lbl_text.textAlignmentProperty().set(this.lbl_text.getBounds().width > textW ? CompassDirection.WEST : CompassDirection.EAST, TSimpleTextFieldWidget.class);
        };
        this.boundsProperty().addChangeListener((p, o, n) -> refresh_alignment.run());
        this.font.addChangeListener((p, o, n) -> {
            this.lbl_placeholder.fontProperty().set((class_327)n, TSimpleTextFieldWidget.class);
            this.lbl_text.fontProperty().set((class_327)n, TSimpleTextFieldWidget.class);
            refresh_alignment.run();
        });
        this.placeholder.addChangeListener((p, o, n) -> this.lbl_placeholder.setText((class_2561)n));
        this.text.addChangeListener((p, o, n) -> {
            this.lbl_text.setText((class_2561)class_2561.method_43470((String)n));
            this.lbl_placeholder.visibleProperty().set(n.isEmpty(), TSimpleTextFieldWidget.class);
            refresh_alignment.run();
        });
    }

    public final NotNullProperty<String> textProperty() {
        return this.text;
    }

    public final NotNullProperty<class_327> fontProperty() {
        return this.font;
    }

    public final NotNullProperty<class_2561> placeholderProperty() {
        return this.placeholder;
    }

    public final TLabelElement getTextLabel() {
        return this.lbl_text;
    }

    public final TLabelElement getPlaceholderLabel() {
        return this.lbl_placeholder;
    }

    @Override
    @Virtual
    @NotNull
    public CursorType getCursor() {
        return this.isFocusable() ? CursorType.IBEAM : CursorType.NOT_ALLOWED;
    }

    @Override
    protected final void initCallback() {
        Bounds2i bb = this.getBounds();
        Bounds2i lbb = new Bounds2i(bb.x + 4, bb.y + 2, bb.width - 8, bb.height - 4);
        this.lbl_placeholder.setBounds(lbb);
        this.add(this.lbl_placeholder);
        this.lbl_text.setBounds(lbb);
        this.add(this.lbl_text);
    }

    @Override
    @Virtual
    public void renderCallback(@NotNull TGuiGraphics pencil) {
        Bounds2i bb = this.getBounds();
        pencil.fillColor(bb.x, bb.y, bb.width, bb.height, -16777216);
    }

    @Override
    @Virtual
    public void postRenderCallback(@NotNull TGuiGraphics pencil) {
        Bounds2i bb = this.getBounds();
        if (this.isHoveredOrFocused()) {
            pencil.drawOutlineIn(bb.x, bb.y, bb.width, bb.height, -5570561);
        } else {
            pencil.drawOutlineIn(bb.x, bb.y, bb.width, bb.height, 0x50FFFFFF);
        }
    }

    @Override
    public final boolean inputCallback(@NotNull TInputContext.InputDiscoveryPhase phase, @NotNull TInputContext context) {
        boolean typed;
        if (super.inputCallback(phase, context)) {
            return true;
        }
        if (phase != TInputContext.InputDiscoveryPhase.MAIN || !this.isFocused()) {
            return false;
        }
        switch (context.getInputType()) {
            case CHAR_TYPE: {
                boolean bl = this.inputText(context.getCharacter().toString());
                break;
            }
            case KEY_PRESS: {
                boolean bl;
                if (context.getKeyCode() == 259 && this.inputBackspace(1)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                boolean bl = typed = false;
            }
        }
        if (typed) {
            TGuiUtils.playGuiTypingSound();
        }
        return typed;
    }

    public final boolean inputText(@NotNull String text) {
        Objects.requireNonNull(text);
        String old_text = this.text.get();
        this.text.set(old_text + text, TSimpleTextFieldWidget.class);
        return !Objects.equals(old_text, this.text.get());
    }

    public final boolean inputBackspace(int amount) {
        String old_text = this.text.get();
        int old_text_len = old_text.length();
        amount = Math.clamp((long)amount, 0, old_text_len);
        this.text.set(old_text.substring(0, old_text_len - amount), TSimpleTextFieldWidget.class);
        return !Objects.equals(old_text, this.text.get());
    }
}

