/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.commonmc.api.stats.util;

import com.thecsdev.commonmc.api.stats.IStatsProvider;
import com.thecsdev.commonmc.api.stats.util.StatFormatterOverride;
import com.thecsdev.commonmc.api.stats.util.SubjectStats;
import com.thecsdev.commonmc.mixin.hooks.AccessorStat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3445;
import net.minecraft.class_3446;
import net.minecraft.class_3468;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CustomStat
extends SubjectStats<class_2960> {
    @NotNull
    private final class_2561 subjectName;
    @NotNull
    private final class_3445<class_2960> stat;
    @NotNull
    private final class_3446 statFormatter;

    public CustomStat(@NotNull class_2960 subject, @NotNull IStatsProvider statsProvider) throws NullPointerException, IllegalStateException {
        super(class_7923.field_41183, subject, statsProvider);
        this.subjectName = IStatsProvider.getCustomStatName(subject);
        this.stat = class_3468.field_15419.method_14956((Object)subject);
        class_3446 f = ((AccessorStat)this.stat).getFormatter();
        this.statFormatter = f != null ? f : class_3446.field_16975;
    }

    @Override
    @NotNull
    public final class_2561 getSubjectDisplayName() {
        return this.subjectName;
    }

    @Override
    @NotNull
    public final LinkedHashMap<class_3445<class_2960>, Integer> getValues() {
        LinkedHashMap<class_3445<class_2960>, Integer> map = new LinkedHashMap<class_3445<class_2960>, Integer>();
        map.put(this.stat, this.getValue());
        return map;
    }

    @Override
    public final boolean isEmpty() {
        return this.getValue() == 0;
    }

    public final int getValue() {
        return this.getStatsProvider().getIntValue(this.stat);
    }

    @NotNull
    public final String getValueF() {
        return this.statFormatter.format(this.getValue());
    }

    @NotNull
    public final String getValueF(@Nullable StatFormatterOverride formatter) {
        if (formatter == null) {
            formatter = StatFormatterOverride.DEFAULT;
        }
        return formatter.format(this.statFormatter, this.getValue());
    }

    public final boolean isDistance() {
        return this.statFormatter == class_3446.field_16977;
    }

    public final boolean isTime() {
        return this.statFormatter == class_3446.field_16979;
    }

    public final boolean isDivideBy10() {
        return this.statFormatter == class_3446.field_16978;
    }

    public static final Collection<CustomStat> getCustomStats(@NotNull IStatsProvider statsProvider, @Nullable Predicate<CustomStat> predicate, @Nullable Comparator<CustomStat> comparator) throws NullPointerException {
        Objects.requireNonNull(statsProvider);
        ArrayList<CustomStat> result = new ArrayList<CustomStat>(predicate == null ? class_7923.field_41183.method_10204() : 0);
        for (class_2960 statSubject : class_7923.field_41183) {
            CustomStat stat = new CustomStat(statSubject, statsProvider);
            if (predicate != null && !predicate.test(stat)) continue;
            result.add(stat);
        }
        if (comparator != null) {
            result.sort(comparator);
        }
        return result;
    }
}

