/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.commonmc.api.stats.util;

import com.thecsdev.commonmc.api.stats.IStatsProvider;
import com.thecsdev.commonmc.api.stats.util.BlockStats;
import com.thecsdev.commonmc.api.stats.util.SubjectStats;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_3445;
import net.minecraft.class_3448;
import net.minecraft.class_3468;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemStats
extends SubjectStats<class_1792> {
    private BlockStats blockStats;

    public ItemStats(@NotNull class_1792 subject, @NotNull IStatsProvider statsProvider) throws NullPointerException, IllegalStateException {
        super(class_7923.field_41178, subject, statsProvider);
    }

    @Override
    @NotNull
    public final class_2561 getSubjectDisplayName() {
        return ((class_1792)this.getSubject()).method_63680();
    }

    @Override
    @NotNull
    public final LinkedHashMap<class_3445<class_1792>, Integer> getValues() {
        class_1792 subject = (class_1792)this.getSubject();
        LinkedHashMap<class_3445<class_1792>, Integer> map = new LinkedHashMap<class_3445<class_1792>, Integer>();
        for (class_3448<class_1792> st : IStatsProvider.getItemStatTypes()) {
            map.put((class_3445<class_1792>)st.method_14956((Object)subject), this.getStatsProvider().getIntValue(st, subject));
        }
        return map;
    }

    @NotNull
    public final BlockStats getItemBlockStats() {
        if (this.blockStats == null) {
            this.blockStats = new BlockStats(class_2248.method_9503((class_1792)((class_1792)this.getSubject())), this.getStatsProvider());
        }
        return this.blockStats;
    }

    public final int getTimesBroken() {
        return this.getStatsProvider().getIntValue(class_3468.field_15383, (class_1792)this.getSubject());
    }

    public final int getTimesCrafted() {
        return this.getStatsProvider().getIntValue(class_3468.field_15370, (class_1792)this.getSubject());
    }

    public final int getTimesDropped() {
        return this.getStatsProvider().getIntValue(class_3468.field_15405, (class_1792)this.getSubject());
    }

    public final int getTimesUsed() {
        return this.getStatsProvider().getIntValue(class_3468.field_15372, (class_1792)this.getSubject());
    }

    public final int getTimesPickedUp() {
        return this.getStatsProvider().getIntValue(class_3468.field_15392, (class_1792)this.getSubject());
    }

    public static final Collection<ItemStats> getItemStats(@NotNull IStatsProvider statsProvider, @Nullable Predicate<ItemStats> predicate, @Nullable Comparator<ItemStats> comparator) throws NullPointerException {
        Objects.requireNonNull(statsProvider);
        ArrayList<ItemStats> result = new ArrayList<ItemStats>(predicate == null ? class_7923.field_41178.method_10204() : 0);
        for (class_1792 statSubject : class_7923.field_41178) {
            ItemStats stat = new ItemStats(statSubject, statsProvider);
            if (predicate != null && !predicate.test(stat)) continue;
            result.add(stat);
        }
        if (comparator != null) {
            result.sort(comparator);
        }
        return result;
    }
}

