/*
 * Decompiled with CFR 0.152.
 */
package com.thecsdev.commonmc.api.stats.util;

import com.thecsdev.common.util.annotations.Virtual;
import com.thecsdev.commonmc.api.stats.IStatsProvider;
import com.thecsdev.commonmc.api.stats.util.BlockStats;
import com.thecsdev.commonmc.api.stats.util.CustomStat;
import com.thecsdev.commonmc.api.stats.util.EntityStats;
import com.thecsdev.commonmc.api.stats.util.ItemStats;
import com.thecsdev.commonmc.api.stats.util.StatFormatterOverride;
import com.thecsdev.commonmc.mixin.hooks.AccessorStat;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3445;
import net.minecraft.class_3446;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract sealed class SubjectStats<S>
permits CustomStat, ItemStats, BlockStats, EntityStats {
    @NotNull
    private final IStatsProvider statsProvider;
    @NotNull
    private final S subject;
    @NotNull
    private final class_2960 subjectID;

    protected SubjectStats(@NotNull class_2378<S> subjectRegistry, @NotNull S subject, @NotNull IStatsProvider statsProvider) throws NullPointerException, IllegalStateException {
        this.statsProvider = Objects.requireNonNull(statsProvider);
        this.subject = Objects.requireNonNull(subject);
        class_2960 subjectID = Objects.requireNonNull(subjectRegistry).method_10221(subject);
        if (subjectID == null) {
            throw new IllegalStateException("'" + String.valueOf(subjectRegistry) + "' does not contain '" + String.valueOf(subject) + "'");
        }
        this.subjectID = subjectID;
    }

    public final int hashCode() {
        return Objects.hash(this.statsProvider, this.subject);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(@Nullable Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof SubjectStats)) return false;
        SubjectStats st = (SubjectStats)obj;
        if (this.statsProvider != st.statsProvider) return false;
        if (this.subject != st.subject) return false;
        return true;
    }

    @NotNull
    public final IStatsProvider getStatsProvider() {
        return this.statsProvider;
    }

    @NotNull
    public final S getSubject() {
        return this.subject;
    }

    @NotNull
    public final class_2960 getSubjectID() {
        return this.subjectID;
    }

    @NotNull
    public abstract class_2561 getSubjectDisplayName();

    @NotNull
    public abstract LinkedHashMap<class_3445<S>, Integer> getValues();

    @NotNull
    public final LinkedHashMap<class_3445<S>, String> getValuesF() {
        return this.getValuesF(StatFormatterOverride.DEFAULT);
    }

    @NotNull
    public final LinkedHashMap<class_3445<S>, String> getValuesF(@NotNull StatFormatterOverride formatter) throws NullPointerException {
        Objects.requireNonNull(formatter);
        LinkedHashMap<class_3445<S>, Integer> vals = this.getValues();
        LinkedHashMap<class_3445<S>, String> map = new LinkedHashMap<class_3445<S>, String>(vals.size());
        for (Map.Entry<class_3445<S>, Integer> entry : vals.entrySet()) {
            class_3445<S> stat = entry.getKey();
            class_3446 statFormatter = ((AccessorStat)stat).getFormatter();
            Integer statValue = entry.getValue();
            map.put(stat, formatter.format(statFormatter, statValue));
        }
        return map;
    }

    @Virtual
    public boolean isEmpty() {
        return this.getValues().values().stream().noneMatch(val -> val != 0);
    }

    @Virtual
    public boolean isSearchMatch(@NotNull String query) throws NullPointerException {
        Objects.requireNonNull(query);
        query = query.replaceAll("[^A-Za-z]", "").toLowerCase(Locale.ENGLISH);
        String sid = this.subjectID.toString().replaceAll("[^A-Za-z]", "").toLowerCase(Locale.ENGLISH);
        String sdn = this.getSubjectDisplayName().getString().replaceAll("[^A-Za-z]", "").toLowerCase(Locale.ENGLISH);
        return sid.contains(query) || sdn.contains(query);
    }
}

